(function () {
  // If debugging is already active, disable it.
  if (window.drasticDebugActive) {
    window.drasticDebugCleanup && window.drasticDebugCleanup();
    chrome.runtime.sendMessage({ debugActive: false });
    return;
  }
  window.drasticDebugActive = true;

  // Inject a global style that outlines every element except the debugger bottom bar.
  if (!document.getElementById('drastic-debug-outline-style')) {
    const outlineStyle = document.createElement('style');
    outlineStyle.id = 'drastic-debug-outline-style';
    outlineStyle.innerHTML = `
        *:not(#drastic-debug-bottom-bar):not(#drastic-debug-bottom-bar *) {
          outline: 1.2px solid #ccc !important;
        }
      `;
    document.head.appendChild(outlineStyle);
  }

  // Inject style for the highlight class.
  if (!document.getElementById('drastic-debug-highlight-style')) {
    const highlightStyle = document.createElement('style');
    highlightStyle.id = 'drastic-debug-highlight-style';
    highlightStyle.innerHTML = `
        .drastic-debug-highlight {
          box-shadow: 0 0 10px white, 0 0 15px black !important;
        }
      `;
    document.head.appendChild(highlightStyle);
  }

  // Create a fixed bottom bar for showing element details.
  const bottomBar = document.createElement('div');
  bottomBar.id = 'drastic-debug-bottom-bar';
  bottomBar.style.position = 'fixed';
  bottomBar.style.bottom = '0';
  bottomBar.style.left = '50%';
  bottomBar.style.transform = 'translateX(-50%)';
  bottomBar.style.background = 'rgba(0, 0, 0, 0.85)';
  bottomBar.style.color = '#fff';
  bottomBar.style.fontSize = '14px';
  bottomBar.style.padding = '10px 20px';
  bottomBar.style.boxSizing = 'border-box';
  bottomBar.style.display = 'none'; // Hidden by default.
  bottomBar.style.zIndex = '10000';
  bottomBar.style.textAlign = 'center';
  bottomBar.style.borderTop = '2px solid #ff5722';
  bottomBar.style.boxShadow = '0 -2px 10px rgba(0, 0, 0, 0.5)';
  bottomBar.style.borderRadius = '5px 5px 0 0';
  document.body.appendChild(bottomBar);

  let currentHighlighted = null;

  // Handler for mouseover: highlight element and show bottom bar if Ctrl is pressed.
  function handleMouseOver(e) {
    const target = e.target;
    // Avoid processing events for the bottom bar.
    if (target.id === 'drastic-debug-bottom-bar') return;

    // Remove highlight from the previous element if it's different.
    if (currentHighlighted && currentHighlighted !== target) {
      currentHighlighted.classList.remove('drastic-debug-highlight');
    }
    currentHighlighted = target;
    currentHighlighted.classList.add('drastic-debug-highlight');

    // If Ctrl is pressed, update and show the bottom bar with details.
    if (e.ctrlKey) {
      const tag = target.tagName.toLowerCase();
      const classes = target.className ? target.className.trim() : 'None';
      const id = target.id ? target.id : 'None';
      // Structure details with different styles.
      const displayClasses =
        classes
          .split(' ')
          .filter((cls) => cls !== 'drastic-debug-highlight')
          .join(' ') || 'None';
      bottomBar.innerHTML = `
          <span style="background-color: #ff5722; color: #fff; padding: 2px 5px; border-radius: 3px;">${tag}</span>
          <span style="color: #ff5722; margin: 0 5px;">|</span>
          <span style="color: #ff5722;">ID:</span> <span style="color: #4caf50;">${id}</span>
          <span style="color: #ff5722; margin: 0 5px;">|</span>
          <span style="color: #ff5722;">Class:</span> <span style="color: #4caf50;">${displayClasses}</span>
        `;
      bottomBar.style.display = 'block';
    } else {
      bottomBar.style.display = 'none';
    }
  }

  // Handler for mouseout: remove the highlight and hide the bottom bar.
  function handleMouseOut(e) {
    const target = e.target;
    if (target === currentHighlighted) {
      target.classList.remove('drastic-debug-highlight');
      bottomBar.style.display = 'none';
      currentHighlighted = null;
    }
  }

  document.addEventListener('mouseover', handleMouseOver);
  document.addEventListener('mouseout', handleMouseOut);

  // Cleanup function to disable debugging.
  window.drasticDebugCleanup = function () {
    const os = document.getElementById('drastic-debug-outline-style');
    if (os) os.remove();
    const hs = document.getElementById('drastic-debug-highlight-style');
    if (hs) hs.remove();
    if (bottomBar) bottomBar.remove();
    document.removeEventListener('mouseover', handleMouseOver);
    document.removeEventListener('mouseout', handleMouseOut);
    if (currentHighlighted) {
      currentHighlighted.classList.remove('drastic-debug-highlight');
      currentHighlighted = null;
    }
    window.drasticDebugActive = false;
  };

  chrome.runtime.sendMessage({ debugActive: true });
})();
