// Function to update the button text based on the debugging state.
function updateButtonText() {
  chrome.tabs.query({ active: true, currentWindow: true }, (tabs) => {
    chrome.scripting.executeScript(
      {
        target: { tabId: tabs[0].id },
        function: () => !!window.drasticDebugActive,
      },
      (results) => {
        const isActive = results && results[0] && results[0].result;
        document.getElementById('toggleDebug').textContent = isActive
          ? 'Disable Debugging'
          : 'Enable Debugging';
      },
    );
  });
}

// Update button text when the popup loads.
updateButtonText();

// Add click listener to toggle debugging.
document.getElementById('toggleDebug').addEventListener('click', () => {
  chrome.tabs.query({ active: true, currentWindow: true }, (tabs) => {
    // Inject content.js which toggles the debugging mode.
    chrome.scripting.executeScript(
      {
        target: { tabId: tabs[0].id },
        files: ['content.js'],
      },
      () => {
        // Update the button text after toggling.
        updateButtonText();
      },
    );
  });
});
